//______________________________________________________________________________
//==============================================================================
// Autostarter
// Version: 1.0
//
// Last update: 2012-02-06
// Project startup: 2012-02-06
//
// Programming: Mateusz Wilczewski
// WebSite: http://wiblo.pl
//
// Opis:
// Program uruchamia do 10 aplikacji, ktre zostay wprowadzone w pliku
// konfiguracyjnym. Pomidzy kadym uruchomieniem wybranych programow aplikacja
// odczekuje okrelony w pliku konfiguracyjnym czas.
//
// Licencja:
// zezwala si na nieodpatne kopiowanie, dystrybucj, uytkowanie (take komercyjne),
// modyfikowanie (zmian, rozbudow) programu oraz kodu zrodlowego.
//
//
//______________________________________________________________________________
//==============================================================================

program autostarter;

{$APPTYPE CONSOLE}

// deklaracja wymaganych modulow
uses
  Windows, SysUtils, Messages, INIFiles, ShellApi;

// Stae
Const
  file_config = 'config.ini';  // plik z konfiguracja
  version = '1.0.0';           // wersja programu

// Zmienne
var
  countdown : integer;      // zmienna licznika odliczajacego
  EndLoop : Boolean;        // zmienna petli glownej programu
  INI_config : TINIFile;    // zmienna do obslugi pliku ini z konfiguracja
  run_program : Array [1..10] of string;  // tablica programw do uruchomienia wczytanych z pliku konfiguracyjnego
  pause : integer;          // zmienna do obslugi pauzy - przerwy pomiedzy uruchomieniami programow
  current_dir : string;     // zmienna do przechowywania katalogu, z ktorego zostala uruchomiona aplikacja


//------------------------------------------------------------------------------
// Procedury
//------------------------------------------------------------------------------

// process messages
procedure ProcessMessages;
var
  Msg: TMsg;
begin
  while PeekMessage(Msg, 0, 0, 0, PM_REMOVE) do begin
    if Msg.Message <> WM_QUIT then begin
      TranslateMessage(Msg);
      DispatchMessage(Msg);
    end else
      exit;
  end;
end;

// pozycjonowanie tekstu, ustawia kursor na ustawionej pozycji
// x - numer wiersza, y - numer kolumny
procedure GotoXY(x,y:integer);
var
 hnd : THandle;
 pos : COORD;
begin
  hnd := GetStdHandle(STD_OUTPUT_HANDLE);
  pos.X:=y;
  pos.Y:=x;
  SetConsoleCursorPosition(hnd,pos);
end;


//------------------------------------------------------------------------------
// Glowny program / petla
//------------------------------------------------------------------------------

begin
  pause:=0;      // inicjalizacja i ustawienie 0
  countdown:=0;  // inicjalizacja i ustawienie 0
  current_dir:=GetCurrentDir; // pobieranie katalogu z ktorego uruchomiona jest aplikacja

  // utworz config.ini jesli nie istnieje
  if not FileExists(file_config) then  // jesli plik config.ini nie istnieje utworz nowy plik
  Begin
    INI_config := TINIFile.Create(current_dir+'\'+file_config); // stworz plik INI na dysku
    try
      // stworz wpisy i ustaw domyslne wartosci
      INI_config.WriteString('Autostart', 'Countdown', '5');                     // domyslna przerwa przed uruchomieniem sekwencji autostart
      INI_config.WriteString('Autostart', 'Pause', '1500');                      // domyslna przerwa pomiedzy kolejnymi uruchomieniami programw
      INI_config.WriteString('Autostart', 'Program1', 'c:\windows\notepad.exe'); // wpisz domyslna wartosc
      INI_config.WriteString('Autostart', 'Program2', '');
      INI_config.WriteString('Autostart', 'Program3', '');
      INI_config.WriteString('Autostart', 'Program4', '');
      INI_config.WriteString('Autostart', 'Program5', '');
      INI_config.WriteString('Autostart', 'Program6', '');
      INI_config.WriteString('Autostart', 'Program7', '');
      INI_config.WriteString('Autostart', 'Program8', '');
      INI_config.WriteString('Autostart', 'Program9', '');
      INI_config.WriteString('Autostart', 'Program10', '');

    finally
      INI_config.Free; // zakoncz dzialanie z plikiem ini
    end;
  End;

  // wczytanie config
  if FileExists(file_config) then  // jesli plik config.ini istnieje odczytaj konfiguracje
  begin
    INI_config := TINIFile.Create(current_dir+'\'+file_config);
    try

      countdown:=1+strtoint(INI_config.ReadString('Autostart','Countdown',''));    // wczytaj odliczanie do startu sekwencji uruchamiania programow
      pause:=strtoint(INI_config.ReadString('Autostart','Pause',''));      // wczytaj pauze pomiedzy uruchomieniami programow
      run_program[1]:=INI_config.ReadString('Autostart','Program1','');    // wczytywanie ustawionych programow
      run_program[2]:=INI_config.ReadString('Autostart','Program2','');
      run_program[3]:=INI_config.ReadString('Autostart','Program3','');
      run_program[4]:=INI_config.ReadString('Autostart','Program4','');
      run_program[5]:=INI_config.ReadString('Autostart','Program5','');
      run_program[6]:=INI_config.ReadString('Autostart','Program6','');
      run_program[7]:=INI_config.ReadString('Autostart','Program7','');
      run_program[8]:=INI_config.ReadString('Autostart','Program8','');
      run_program[9]:=INI_config.ReadString('Autostart','Program9','');
      run_program[10]:=INI_config.ReadString('Autostart','Program10','');

    finally
      INI_config.Free;  // zakoncz dzialanie z plikiem ini
    end;
  End;

  EndLoop:=False;  // zmienna ptli glownej ustawiana na FALSE

  while EndLoop=False do // petla programu - dopoki EndLoop jest FALSE
  begin
    dec(countdown); // zwieksz
    gotoxy(0,0);
    writeln('====================================================================');
    gotoxy(1,0);
    writeln('AutoStart version: '+version+'                       http://wiblo.pl 2012');
    gotoxy(2,0);
    writeln('Countdown: '+inttostr(countdown)+' ');
    gotoxy(2,15);
    writeln('ms');
    gotoxy(3,0);
    writeln('====================================================================');
    ProcessMessages;
    writeln('Program 1: '+run_program[1]);
    writeln('Program 2: '+run_program[2]);
    writeln('Program 3: '+run_program[3]);
    writeln('Program 4: '+run_program[4]);
    writeln('Program 5: '+run_program[5]);
    writeln('Program 6: '+run_program[6]);
    writeln('Program 7: '+run_program[7]);
    writeln('Program 8: '+run_program[8]);
    writeln('Program 9: '+run_program[9]);
    writeln('Program 10: '+run_program[10]);
    Sleep(1000);
    if countdown<=0 then // jezeli odliczenia zakonczone
    begin
      sleep(100); // odczekaj 100 ms przed sprawdzaniem listy programow do uruchomienia
      if length(run_program[1])>2 Then // sprawdzanie czy tablica jest uzupelniona jesli nie sprawdz nastepny, jesli tak wykonaj instrukcje
      begin
        ShellExecute(0, 'open', PChar(run_program[1]), nil, nil, SW_SHOWNORMAL);  // uruchomienie programu/pliku
        writeln('Program1.............................................EXECUTED'); // wypisz informacje, ze wykonano instrukcje dla pola Program 1
        sleep(pause);
      end;
      if length(run_program[2])>2 Then
      begin
        ShellExecute(0, 'open', PChar(run_program[2]), nil, nil, SW_SHOWNORMAL);
        writeln('Program2.............................................EXECUTED');
        sleep(pause);
      end;
      if length(run_program[3])>2 Then
      begin
        ShellExecute(0, 'open', PChar(run_program[3]), nil, nil, SW_SHOWNORMAL);
        writeln('Program3.............................................EXECUTED');
        sleep(pause);
      end;
      if length(run_program[4])>2 Then
      begin
        ShellExecute(0, 'open', PChar(run_program[4]), nil, nil, SW_SHOWNORMAL);
        writeln('Program4.............................................EXECUTED');
        sleep(pause);
      end;
      if length(run_program[5])>2 Then
      begin
        ShellExecute(0, 'open', PChar(run_program[5]), nil, nil, SW_SHOWNORMAL);
        writeln('Program5.............................................EXECUTED');
        sleep(pause);
      end;
      if length(run_program[6])>2 Then
      begin
        ShellExecute(0, 'open', PChar(run_program[6]), nil, nil, SW_SHOWNORMAL);
        writeln('Program6.............................................EXECUTED');
        sleep(pause);
      end;
      if length(run_program[7])>2 Then
      begin
        ShellExecute(0, 'open', PChar(run_program[7]), nil, nil, SW_SHOWNORMAL);
        writeln('Program7.............................................EXECUTED');
        sleep(pause);
      end;
       if length(run_program[8])>2 Then
      begin
        ShellExecute(0, 'open', PChar(run_program[8]), nil, nil, SW_SHOWNORMAL);
        writeln('Program8.............................................EXECUTED');
        sleep(pause);
      end;
      if length(run_program[9])>2 Then
      begin
        ShellExecute(0, 'open', PChar(run_program[9]), nil, nil, SW_SHOWNORMAL);
        writeln('Program9.............................................EXECUTED');
        sleep(pause);
      end;
      if length(run_program[10])>2 Then
      begin
        ShellExecute(0, 'open', PChar(run_program[10]), nil, nil, SW_SHOWNORMAL);
        writeln('Program10............................................EXECUTED');
        sleep(pause);
      end;

      EndLoop:=True; // ustaw EndLoop na True i zakoncz glowna petle
    end;
  end;
  //KillTimer(0, id);

  writeln('Closing program...'); // wypisz info
  sleep(2000); // odczekaj 2 sekundy przed zakonczenim programu
end.
